<?php
// api/bncs_workstation.php
// Same-origin proxy to internal BNCS API.

ini_set('display_errors', 0);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=utf-8');

$id = isset($_GET['id']) ? trim($_GET['id']) : '';
if ($id === '' || !ctype_digit($id)) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'invalid or missing id']);
    exit;
}

$bncsBase = 'http://10.65.10.49:8080/bncsinfo/workstations/';
$upstream = $bncsBase . $id;

// optional: small per-request log for quick triage
$logFile = '/tmp/bncs_proxy.log';
$log = function($msg) use ($logFile) {
    @file_put_contents($logFile, '['.date('c')."] $msg\n", FILE_APPEND);
};

$ch = curl_init($upstream);

// capture verbose cURL output for deep debugging
$verboseStream = fopen('php://temp', 'w+');

curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER  => true,
    CURLOPT_FOLLOWLOCATION  => true,
    CURLOPT_MAXREDIRS       => 5,
    CURLOPT_TIMEOUT         => 10,
    CURLOPT_CONNECTTIMEOUT  => 5,
    CURLOPT_HTTPGET         => true,
    CURLOPT_HTTPHEADER      => ['Accept: application/json'],
    CURLOPT_PROXY           => '',                 // disable env proxy
    CURLOPT_NOPROXY         => '10.65.10.49',
    CURLOPT_HEADER          => false,
    CURLOPT_VERBOSE         => true,
    CURLOPT_STDERR          => $verboseStream,
    // Uncomment if upstream is picky about HTTP/1.1
    // CURLOPT_HTTP_VERSION     => CURL_HTTP_VERSION_1_1,
]);

$body = curl_exec($ch);
$curlErr  = curl_error($ch);
$info     = curl_getinfo($ch);
$code     = (int)($info['http_code'] ?? 0);

rewind($verboseStream);
$verboseDump = stream_get_contents($verboseStream);
fclose($verboseStream);

if ($body === false) {
    http_response_code(502);
    $log("ERR curl_exec: $curlErr | URL=$upstream | INFO=" . json_encode($info));
    echo json_encode([
        'ok'       => false,
        'error'    => $curlErr ?: 'curl_exec failed',
        'upstream' => $upstream,
        'info'     => $info,
        'verbose'  => substr($verboseDump, 0, 2000),
    ], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
    curl_close($ch);
    exit;
}

curl_close($ch);

// Try decode even on non-2xx
$decoded = json_decode($body, true);

// Pass through the upstream status so you see the real code
http_response_code($code);
header('X-Upstream-Code: '.$code);

if ($code >= 200 && $code < 300) {
    echo json_encode([
        'ok'   => true,
        'data' => is_array($decoded) ? $decoded : $body,
    ], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
    exit;
}

// Non-2xx: include useful diagnostics
echo json_encode([
    'ok'       => false,
    'error'    => "upstream HTTP $code",
    'upstream' => $upstream,
    'info'     => $info,
    'body'     => is_array($decoded) ? $decoded : mb_substr($body, 0, 1000),
    'verbose'  => substr($verboseDump, 0, 2000),
], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
