<?php
// api/device_counts.php
declare(strict_types=1);
header('Content-Type: application/json');
ini_set('display_errors','0');
ini_set('log_errors','1');
ini_set('error_log','/tmp/liveconn-row.log');
error_reporting(E_ALL);


require_once __DIR__ . '../../../env_vars.php';
if (!load_env('/etc/netbox/secrets.env'))
{
    http_response_code(500); echo json_encode(['ok'=>false]);
    exit;
}

$DB_HOST = $_SERVER['LIVECONNECTIONS_DATABASE_HOST'];
$DB_PORT = $_SERVER['LIVECONNECTIONS_DATABASE_PORT'];
$DB_NAME = $_SERVER['LIVECONNECTIONS_DATABASE_NAME'];
$DB_USER = $_SERVER['LIVECONNECTIONS_DATABASE_USER'];
$DB_PASS = $_SERVER['LIVECONNECTIONS_DATABASE_PASSWORD'];
$DB_SERVICES_TABLE = $_SERVER['LIVECONNECTIONS_IPATH_SERVICE_TABLE'];
$DB_ROUTING_PLANES_TABLE = $_SERVER['LIVECONNECTIONS_IPATH_ROUTING_PLANES_TABLE'];
$DB_NETBOX_LOOKUP_CACHE_TABLE = $_SERVER['LIVECONNECTIONS_NETBOX_LOOKUP_CACHE_TABLE'];

function pdo_conn($h,$p,$d,$u,$pw){
    return new PDO("pgsql:host=$h;port=$p;dbname=$d", $u, $pw, [
        PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_EMULATE_PREPARES=>false
    ]);
}

$idsCsv = trim((string)($_GET['ids'] ?? ''));
$ids = array_values(array_filter(array_map('trim', explode(',', $idsCsv))));
if (!$ids) { echo json_encode(['ok'=>true, 'counts'=>[]]); exit; }

try {
    $pdo = pdo_conn($DB_HOST,$DB_PORT,$DB_NAME,$DB_USER,$DB_PASS);
    $sql = "WITH req AS (
  SELECT unnest(:ids::text[]) AS device_id
)
SELECT
  r.device_id,
  COALESCE( COUNT(*) FILTER (WHERE s.from_device_id = r.device_id), 0 ) AS from_count,
  COALESCE( COUNT(*) FILTER (WHERE s.to_device_id   = r.device_id), 0 ) AS to_count
FROM req r
LEFT JOIN " . $DB_SERVICES_TABLE. " s
  ON (s.from_device_id = r.device_id OR s.to_device_id = r.device_id)
GROUP BY r.device_id
";


    $stmt = $pdo->prepare($sql);
    // cast to Postgres array
    $stmt->bindValue(':ids', '{'.implode(',', array_map(fn($s)=>'"'.addslashes($s).'"', $ids)).'}', PDO::PARAM_STR);
    $stmt->execute();
    $out = [];
    while ($r = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $out[$r['device_id']] = ['from_count'=>(int)$r['from_count'], 'to_count'=>(int)$r['to_count']];
    }
    echo json_encode([
        'ok'=>true,
        'timestamp'      => date('c'),
        'counts'=>$out]
    );
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['ok'=>false]);
}
