<?php
header('Content-Type: application/json');

require '../../env_vars.php';
if (!load_env('/etc/netbox/secrets.env')) { echo json_encode(['ok'=>false,'error'=>'bad config']); exit; }

$DB_HOST = $_SERVER['LIVECONNECTIONS_DATABASE_HOST'];
$DB_PORT = $_SERVER['LIVECONNECTIONS_DATABASE_PORT'];
$DB_NAME = $_SERVER['LIVECONNECTIONS_DATABASE_NAME'];
$DB_USER = $_SERVER['LIVECONNECTIONS_DATABASE_USER'];
$DB_PASS = $_SERVER['LIVECONNECTIONS_DATABASE_PASSWORD'];
$DB_SERVICES_TABLE = $_SERVER['LIVECONNECTIONS_IPATH_SERVICE_TABLE'];

$rp = "Unknown";

try {
    $pdo = new PDO("pgsql:host=$DB_HOST;port=$DB_PORT;dbname=$DB_NAME", $DB_USER, $DB_PASS, [
        PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION
    ]);

    // DISTINCT with simple null handling
    $dc = $pdo->query("SELECT DISTINCT ipath_instance FROM {$DB_SERVICES_TABLE} WHERE ipath_instance IS NOT NULL ORDER BY ipath_instance")->fetchAll(PDO::FETCH_COLUMN);
    $sp = $pdo->query("SELECT DISTINCT service_profile FROM {$DB_SERVICES_TABLE} WHERE service_profile IS NOT NULL ORDER BY service_profile")->fetchAll(PDO::FETCH_COLUMN);

    echo json_encode([
        'ok'=>true,
        'timestamp'      => date('c'),
        'ipath_instance'=>$dc,
        'service_profile'=>$sp,
        'routing_plane'=>$rp]
    );
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>$e->getMessage()]);
}
