<?php
// api/ipath_sender_bookings.php
ini_set('display_errors','0');
ini_set('log_errors','1');
ini_set('error_log','/tmp/liveconn-sender-bookings.log');
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

require '../../env_vars.php';
if (!load_env('/etc/netbox/secrets.env')) {
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'config']); exit;
}

$DB_HOST=$_SERVER['LIVECONNECTIONS_DATABASE_HOST'];
$DB_PORT=$_SERVER['LIVECONNECTIONS_DATABASE_PORT'];
$DB_NAME=$_SERVER['LIVECONNECTIONS_DATABASE_NAME'];
$DB_USER=$_SERVER['LIVECONNECTIONS_DATABASE_USER'];
$DB_PASS=$_SERVER['LIVECONNECTIONS_DATABASE_PASSWORD'];
$DB_SERVICES_TABLE = $_SERVER['LIVECONNECTIONS_IPATH_SERVICE_TABLE'];
$DB_ROUTING_PLANES_TABLE = $_SERVER['LIVECONNECTIONS_IPATH_ROUTING_PLANES_TABLE'];
$DB_NETBOX_LOOKUP_CACHE_TABLE = $_SERVER['LIVECONNECTIONS_NETBOX_LOOKUP_CACHE_TABLE'];

$q = trim((string)($_GET['sender'] ?? ''));
if ($q==='') {
    echo json_encode(['ok'=>false,'error'=>'missing sender query']);
    exit;
}

try {
    $pdo = new PDO("pgsql:host=$DB_HOST;port=$DB_PORT;dbname=$DB_NAME", $DB_USER, $DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);

    $sql = "
select booking_id, booking_version, descriptor_label, service_profile, from_ipath_logical_source_id, source_button_name, to_ipath_logical_dest_id, dest_button_name, profile_type, from_device, to_device , start_fmt, end_fmt, infinite, created_by
from {$DB_SERVICES_TABLE}
where from_ipath_logical_source_id = :sender
order by booking_id, booking_version;
";
    $st = $pdo->prepare($sql);
    $st->execute([':sender'=>$q]);

    echo json_encode([
        'ok'=>true,
        'timestamp'      => date('c'),
        'sender'=>$q,
        'bookings'=>$st->fetchAll(PDO::FETCH_ASSOC)
    ], JSON_UNESCAPED_SLASHES);

} catch(Throwable $e) {
    error_log('[senderBookings] '.$e->getMessage());
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'server']);
}
