<?php
// api/sender_counts.php
declare(strict_types=1);
header('Content-Type: application/json');

require_once __DIR__ . '../../../env_vars.php';
if (!load_env('/etc/netbox/secrets.env')) { http_response_code(500); echo json_encode(['ok'=>false]); exit; }

$DB_HOST = $_SERVER['LIVECONNECTIONS_DATABASE_HOST'];
$DB_PORT = $_SERVER['LIVECONNECTIONS_DATABASE_PORT'];
$DB_NAME = $_SERVER['LIVECONNECTIONS_DATABASE_NAME'];
$DB_USER = $_SERVER['LIVECONNECTIONS_DATABASE_USER'];
$DB_PASS = $_SERVER['LIVECONNECTIONS_DATABASE_PASSWORD'];
$DB_SERVICE_TABLE = $_SERVER['LIVECONNECTIONS_IPATH_SERVICE_TABLE'];

function pdo_conn($h,$p,$d,$u,$pw){
    return new PDO("pgsql:host=$h;port=$p;dbname=$d", $u, $pw, [
        PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_EMULATE_PREPARES=>false
    ]);
}

$idsCsv = trim((string)($_GET['ids'] ?? ''));
$ids = array_values(array_filter(array_map('trim', explode(',', $idsCsv))));
if (!$ids) { echo json_encode(['ok'=>true, 'counts'=>[]]); exit; }

// Build a Postgres text[] literal: {"id1","id2",...}
$arrayLiteral = '{' . implode(',', array_map(
        fn($s) => '"' . str_replace('"', '\"', $s) . '"',
        $ids
    )) . '}';

try {
    $pdo = pdo_conn($DB_HOST,$DB_PORT,$DB_NAME,$DB_USER,$DB_PASS);
    $sql = "
SELECT
  from_ipath_logical_source_id AS sender_id,
  COUNT(*) AS n
FROM {$DB_SERVICE_TABLE} 
WHERE from_ipath_logical_source_id = ANY(:ids::text[])
GROUP BY from_ipath_logical_source_id;
";

    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':ids', $arrayLiteral, PDO::PARAM_STR);
    $stmt->execute();

    $out = [];
    while ($r = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $out[$r['sender_id']] = (int)$r['n'];
    }

    echo json_encode([
        'ok' => true,
        'timestamp'      => date('c'),
        'counts' => $out]
    );

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['ok'=>false, 'error' =>500 ]);
}
