<?php
// api/ipath_sender_bookings.php
ini_set('display_errors','0');
ini_set('log_errors','1');
ini_set('error_log','/tmp/liveconn-sender-list-errors.log');
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');


require_once __DIR__ . '../../../env_vars.php';

if (!load_env('/etc/netbox/secrets.env')) {
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'config']); exit;
}

$DB_HOST=$_SERVER['LIVECONNECTIONS_DATABASE_HOST'];
$DB_PORT=$_SERVER['LIVECONNECTIONS_DATABASE_PORT'];
$DB_NAME=$_SERVER['LIVECONNECTIONS_DATABASE_NAME'];
$DB_USER=$_SERVER['LIVECONNECTIONS_DATABASE_USER'];
$DB_PASS=$_SERVER['LIVECONNECTIONS_DATABASE_PASSWORD'];
$DB_SERVICES_TABLE = $_SERVER['LIVECONNECTIONS_IPATH_SERVICE_TABLE'];
$DB_ROUTING_PLANES_TABLE = $_SERVER['LIVECONNECTIONS_IPATH_ROUTING_PLANES_TABLE'];
$DB_NETBOX_LOOKUP_CACHE_TABLE = $_SERVER['LIVECONNECTIONS_NETBOX_LOOKUP_CACHE_TABLE'];


// 1. Initialize the input source array
$input = [];

// 2. Load HTTP GET parameters (This is what you need for the web call)
// This will work regardless of SAPI environment.
$input = array_merge($input, $_GET);

// 3. Load CLI named arguments ONLY if running on the command line
if (php_sapi_name() === 'cli') {
    // getopt() will parse arguments like --device_id=device60
    $options = getopt("", ["device_id:"]);

    // Merge CLI options. If 'device_id' exists in $_GET and $options,
    // the $_GET value (loaded first) will be overwritten by $options.
    // If you prefer CLI to be secondary, reverse the merge order.
    // For this case, we'll keep the simple merge:
    $input = array_merge($input, $options);
}

// --- Validation Check ---
// The device_id MUST be present in the combined $input array now.
if (!isset($input['device_id']) || $input['device_id'] === '') {
    // Failure Block

    // Set header for HTTP response only if not running in CLI
    if (php_sapi_name() !== 'cli' && !headers_sent()) {
        header('Content-Type: application/json');
    }

    echo json_encode(['ok' => false, 'error' => 'missing device_id query']);
    exit;
}

// Assign the device_id
$device_id = $input['device_id'];


try {
    $pdo = new PDO("pgsql:host=$DB_HOST;port=$DB_PORT;dbname=$DB_NAME", $DB_USER, $DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);

    $sql = "
select booking_id, booking_version, descriptor_label, service_profile, from_ipath_logical_source_id, source_button_name, to_ipath_logical_dest_id, dest_button_name, profile_type, from_device, to_device , start_fmt, end_fmt, infinite, created_by
from {$DB_SERVICES_TABLE}
where to_device_id = :device 
order by to_ipath_logical_dest_id;
";

    $st = $pdo->prepare($sql);
    $st->execute([':device'=>$device_id]);

    echo json_encode([
        'ok'=>true,
        'timestamp'      => date('c'),
        'sender'=>$q,
        'bookings'=>$st->fetchAll(PDO::FETCH_ASSOC)
    ], JSON_UNESCAPED_SLASHES);

} catch(Throwable $e) {
    error_log('[sender_list] '.$e->getMessage());
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'server']);
}
