<?php
// api/services_flat_row.php
declare(strict_types=1);
header('Content-Type: application/json');

require_once __DIR__ . '../../../env_vars.php';
if (!load_env('/etc/netbox/secrets.env')) { http_response_code(500); echo json_encode(['present'=>false]); exit; }

$DB_HOST = $_SERVER['LIVECONNECTIONS_DATABASE_HOST'];
$DB_PORT = $_SERVER['LIVECONNECTIONS_DATABASE_PORT'];
$DB_NAME = $_SERVER['LIVECONNECTIONS_DATABASE_NAME'];
$DB_USER = $_SERVER['LIVECONNECTIONS_DATABASE_USER'];
$DB_PASS = $_SERVER['LIVECONNECTIONS_DATABASE_PASSWORD'];
$DB_SERVICES_TABLE = $_SERVER['LIVECONNECTIONS_IPATH_SERVICE_TABLE'];
$DB_ROUTING_PLANES_TABLE = $_SERVER['LIVECONNECTIONS_IPATH_ROUTING_PLANES_TABLE'];
$DB_NETBOX_LOOKUP_CACHE_TABLE = $_SERVER['LIVECONNECTIONS_NETBOX_LOOKUP_CACHE_TABLE'];

$bid  = (string)($_GET['booking_id'] ?? '');
$bver = (int)($_GET['booking_version'] ?? '');

if ($bid === '' || $bver === '') { echo json_encode(['present'=>false,'error'=>'bad args']); exit; }

function pdo_conn($h,$p,$d,$u,$pw){
    return new PDO("pgsql:host=$h;port=$p;dbname=$d", $u, $pw, [
        PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_EMULATE_PREPARES=>false
    ]);
}

$sql = "
SELECT
  d.booking_id,
  d.booking_version,
  d.ipath_instance,
  d.service_profile,
  d.descriptor_label,
  d.descriptor_description,
  d.from_ipath_logical_source_id,
  d.source_button_name,
  d.from_ip_multicast,
  d.to_ipath_logical_dest_id,
  d.dest_button_name,
  rp.routing_plane_name,
  d.from_sdp_file,
  d.start_fmt,
  d.end_fmt,
  d.created_by,
  d.infinite,

  d.from_device,
  d.to_device,

  d.from_device->>'Device' AS from_device_id,
  d.to_device->>'Device'   AS to_device_id,

  COALESCE(nd_from.netbox_device_name, d.from_device->>'Device') AS from_display_name,
  COALESCE(nd_to.netbox_device_name,   d.to_device->>'Device')   AS to_display_name

FROM {$DB_SERVICES_TABLE} d
JOIN {$DB_ROUTING_PLANES_TABLE} rp ON d.profile_type = rp.profile_tag
LEFT JOIN {$DB_NETBOX_LOOKUP_CACHE_TABLE} nd_from
  ON nd_from.ipath_device_id = d.from_device->>'Device' AND nd_from.expires > now()
LEFT JOIN {$DB_NETBOX_LOOKUP_CACHE_TABLE} nd_to
  ON nd_to.ipath_device_id   = d.to_device->>'Device'   AND nd_to.expires > now()
WHERE d.booking_id = :bid::text AND d.booking_version = :bver::bigint
ORDER BY d.start_fmt DESC
LIMIT 1;
";

try {
    $pdo = pdo_conn($DB_HOST,$DB_PORT,$DB_NAME,$DB_USER,$DB_PASS);
    $st = $pdo->prepare($sql);
    $st->execute([':bid'=>$bid, ':bver'=>$bver]);
    $row = $st->fetch(PDO::FETCH_ASSOC);
    echo json_encode([
        'ok' => true,
        'timestamp'      => date('c'),
        'present'=>!!$row,
        'error'=>'none',
        'data'=>$row ?: null]
    );

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['present'=>false, 'response'=>500]);
}
